#version 150
#extension GL_EXT_gpu_shader4 : enable
///////////////////////////////////////////////////////////////////////////////////////////////////
// iStripper wrapper for Shadertoy conversions by @Calgon  //
///////////////////////////////////////////////////////////////////////////////////////////////////
//
// Notes
//
// Idea was to create a standard wrapper around Shadertoy code that could be applied to any shader
// sourced from Shadertoy.
// Version number is 150 as standard but where later functions are found this is changed to 330

// Wrapper Follows....
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Declare the missing thingamies that aren't available on VGHD
uniform vec3  iChannelResolution[4];	// BUT WE NEED TO FILL THEM !
uniform float iChannelTime[4];

//#define iResolution u_WindowSize
#define iResolution vec3(u_WindowSize, 0)	// Because Shadertoy iResolution is a vec3
#define iFrame 0


//Slow the time functions down a little as standard
//#define iTime u_Elapsed * .5
float iTime;

#define iGlobalTime u_Elapsed * .5

// Seems the word texture is important and should not be replaced.  Therefore we must replace
// Shadertoy texture0..3 with texture 0..3 further down
uniform sampler2D texture0; //Random Surfaces
uniform sampler2D texture1; //Water
uniform sampler2D texture2; //Random Greys
uniform sampler2D texture3; //More surfaces

vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture(sampler,fract(P),Bias);}

#define texture texture2D_Fract	// So whenever Shadertoy says "texture" we run it through this Macro
// Can we do the same for Cubemaps 

#define iChannel0 texture0
#define iChannel1 texture1
#define iChannel2 texture2
#define iChannel3 texture3

// Mouse Simulation from @TheEmu	
#define iMouse vec4(0.)
// Alternative Macro if iMouse is better moving
//#define iMouse AUTO_MOUSE  //vec4(0.0,0.0,0.0,0.0)
// Simple "Automatic Mouse". Simulates scanning the mouse over the full range of
// the screen with the X and Y scanning frequencies being different. TheEmu.
#define MOUSE_SPEED vec2(0.5,0.577777) * 0.2
//#define MOUSE_POS vec2((0.25+sin(iTime*MOUSE_SPEED*2))*u_WindowSize/2.0)
//#define MOUSE_POS vec2((sin(iTime*1)*.5*u_WindowSize.x/2.0),1.0*u_WindowSize.y/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
#define MOUSE_PRESS vec2(1.0,1.0)
#define AUTO_MOUSE vec4( MOUSE_POS, MOUSE_PRESS )



vec4 iDate;


///////////////////////////////////////////////////////////////////////////////////////////////////
// Uniforms to control timing of each shader
//uniform float cycle_time;
uniform float bgnum;
uniform float maxbgnum;
//uniform float alpha_off;
//uniform float alpha_on;
//uniform float alpha_always_on;
uniform float scene_duration;


///////////////////////////////////////////////////////////////////////////////////////////////////
// Extract a pixel from texture1 to get the random number
float randNum = texture(texture2, vec2(0.0, 0.0)).r;
float seed_start = 3*randNum-1.5;



///////////////////////////////////////////////////////////////////////////////////////////////////
// Shadertoy Code follows
///////////////////////////////////////////////////////////////////////////////////////////////////

// Sourced from https://www.shadertoy.com/view/Md3XRM

vec3 LIGHT = normalize(vec3(-0.3,0.2,-0.1));

float FULL_SIZE = 2.0;
float EDGE_SIZE = 0.2;
float PAIR_SIZE = 0.2;

vec3 n3(vec3 n)
{
 	return fract(cos(dot(n,vec3(813,12,376)))*vec3(901.81,827.46,615.79));   
}
vec3 model(vec3 p)
{
    float A = p.z/3.0+iTime*0.25;
    vec3 R = vec3(cos(A),sin(A),0);
    vec3 C = vec3(mod(p.xy+8.,16.)-8.+R.yx*vec2(1,-1),fract(p.z)-0.5);
    
    float H = min(length(C.xy+R.xy*FULL_SIZE),length(C.xy-R.xy*FULL_SIZE))*0.5-EDGE_SIZE;
    float P = max(length(vec2(dot(C.xy,R.yx*vec2(1,-1)),C.z))-PAIR_SIZE,length(C.xy)-FULL_SIZE);
    
    float T = FULL_SIZE+0.01+2.*EDGE_SIZE-length(C.xy);
    return vec3(min(H,P),T,P);  
}
vec3 normal(vec3 p)
{
 	vec2 N = vec2(-0.04, 0.04);

 	return normalize(model(p+N.xyy).x*N.xyy+model(p+N.yxy).x*N.yxy+
                     model(p+N.yyx).x*N.yyx+model(p+N.xxx).x*N.xxx);
}
vec4 raymarch(vec3 p, vec3 d)
{
    vec4 M = vec4(p+d*2.0,0);
 	for(int i = 0; i<100;i++)
    {
        float S = model(M.xyz).x;
    	M += vec4(d,1) * S;
        if (S<0.01 || M.w>50.0) break;
    }
    return M;
}
vec3 sky(vec3 d)
{
    float L = dot(d,LIGHT);
 	return vec3(0.3,0.5,0.6)-0.3*(-L*0.5+0.5)+exp2(32.0*(L-1.0));   
}
vec3 color(vec3 p, vec3 d)
{
    vec2 M = model(p).yz;
    float A = atan(mod(p.y+8.,16.)-8.,8.-mod(p.x+8.,16.));
    float T1 = ceil(fract(cos(floor(p.z)*274.63))-0.5);
    float T2 = sign(fract(cos(floor(p.z-80.0)*982.51))-0.5);
    float T3 = T2*sign(cos(p.z/3.0+iTime*0.25+A));

    float L = dot(normal(p),LIGHT)*0.5+0.5;
    float R = max(dot(reflect(d,normal(p)),LIGHT),0.0);
    vec3 C = mix(mix(vec3(0.9-0.8*T3,0.9-0.6*T3,T3),vec3(1.0-0.6*T3,0.2+0.8*T3,0.1*T3),T1),vec3(0.2),step(0.01,M.y));
 	C = mix(C,vec3(0.2,0.5,1.0),step(0.01,-M.x));
    return	C*L+pow(R,16.0);
}
void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 A = iMouse.xy / iResolution.xy * vec2(2,1) * 3.1416;
    vec3 D = vec3(cos(A.x)*sin(A.y),sin(A.x)*sin(A.y),cos(A.y));
    D = mix(vec3(1,0,0),D,ceil((A.x+A.y)/10.0));
    vec3 P = D*12.0-vec3(0,0,iTime*2.0);
    
    vec3 X = normalize(-D);
    vec3 Y = normalize(cross(X,vec3(0,0,1)));
    vec3 Z = normalize(cross(X,Y));
    
	vec2 UV = (fragCoord.xy - iResolution.xy * 0.5) / iResolution.y;
    vec3 R = normalize(mat3(X,Y,Z) * vec3(1,UV));
    
    vec4 M = raymarch(P,R);
    vec3 C = mix(color(M.xyz,R),sky(R),smoothstep(0.5,1.0,M.w/50.0));
	fragColor = vec4(C,1);
}


///////////////////////////////////////////////////////////////////////
// Shadertoy footer wrapper
///////////////////////////////////////////////////////////////////////

void main ( void )
{
	float alpha_on;
	float alpha_off;


	if (bgnum > 0){
		alpha_on  = scene_duration * (bgnum - 1.);
		alpha_off = scene_duration * (bgnum + 0.);
	}
	if (bgnum == 0){
		alpha_on  = scene_duration * (maxbgnum) - 1;
		alpha_off = scene_duration * (maxbgnum) + 1;
	}

	
	
	

	iTime = u_Elapsed * .5;


	if (iTime > 6000.){
		iTime = 6000. * fract(iTime / 6000.);
	}
	float cycle_time = maxbgnum * scene_duration;
	float cycles = (u_Elapsed)/cycle_time;
	float full_cycles = trunc(cycles);
    float part_cycles = u_Elapsed - (full_cycles * cycle_time);
	
	vec4 blank = vec4(0.);
	
	// Run the full program only at the right time..
	if ((part_cycles > alpha_on-1.)&&(part_cycles <= alpha_off+1.)){
		mainImage ( gl_FragColor, gl_FragCoord.xy );
		gl_FragColor.a = 1.0;
	}
	// Otherwise... just blank => massive performance boost
	else{
		gl_FragColor = blank;		
    }
	// Still need to fade it
	gl_FragColor.a = 0.0;
   if (part_cycles > alpha_on-1.){
	if (part_cycles <= alpha_off){
		gl_FragColor.a = 1.;
		if ((alpha_off - part_cycles)<1.){
			gl_FragColor.a = alpha_off - part_cycles;
		}
	}
   }
}


